using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;

using System.Windows.Forms;


namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgViewAutologousDirectedUnits
	/// </summary>
	public class DlgViewAutologousDirectedUnits : gov.va.med.vbecs.GUI.VbecsBaseForm
	{

		#region variables

		// Holds records used to populate both ListViews as well as Details, Restricted, and Assigned tabs
        private DataTable _dtUnits;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpSelectedUnit;
		private gov.va.med.vbecs.GUI.controls.BloodUnitLabel bloodBagLabel1;
		private System.Windows.Forms.Button btnOK;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private System.Windows.Forms.TabControl tabUnits;
		private System.Windows.Forms.TabPage pageAutologous;
		private System.Windows.Forms.ListView lvAutologousUnits;
		private System.Windows.Forms.TabPage pageAssigned;
		private System.Windows.Forms.ListView lvAssignedUnits;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgViewAutologousDirectedUnits()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patientGuid"></param>
		public DlgViewAutologousDirectedUnits(Guid patientGuid)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();
			//
			SetComponentProperties();
			//
			this.patientDisplayPanel1.Patient = new BOL.Patient(patientGuid);
			// When coming from UC16, this display is for informational purposes.  Everything should be write only! 
			this.lvAutologousUnits.CheckBoxes = false;
			//this.lvAutologousUnits.Columns.Add("Product Location", 120, HorizontalAlignment.Left);
		
			LoadForm(patientGuid);
		}

		#endregion


		#region methods

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC016.DlgViewAutologousDirectedUnits());
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DlgViewAutologousDirectedUnits));
            this.btnOK = new System.Windows.Forms.Button();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.grpSelectedUnit = new System.Windows.Forms.GroupBox();
            this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
            this.bloodBagLabel1 = new gov.va.med.vbecs.GUI.controls.BloodUnitLabel(this.components);
            this.tabUnits = new System.Windows.Forms.TabControl();
            this.pageAutologous = new System.Windows.Forms.TabPage();
            this.lvAutologousUnits = new System.Windows.Forms.ListView();
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageAssigned = new System.Windows.Forms.TabPage();
            this.lvAssignedUnits = new System.Windows.Forms.ListView();
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.grpSelectedUnit.SuspendLayout();
            this.tabUnits.SuspendLayout();
            this.pageAutologous.SuspendLayout();
            this.pageAssigned.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(736, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Autologous, Directed, or Assigned Units";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.Location = new System.Drawing.Point(0, 475);
            this.lblRequiredField.TabIndex = 6;
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.Location = new System.Drawing.Point(660, 464);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 2;
            this.btnOK.Text = "&OK";
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 72);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 388);
            this.grpImage.TabIndex = 5;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 0;
            this.pictureBox1.TabStop = false;
            // 
            // grpSelectedUnit
            // 
            this.grpSelectedUnit.AccessibleDescription = "Select Unit Details";
            this.grpSelectedUnit.AccessibleName = "Select Unit Details";
            this.grpSelectedUnit.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpSelectedUnit.Controls.Add(this.bloodUnitDetailsTab1);
            this.grpSelectedUnit.Controls.Add(this.bloodBagLabel1);
            this.grpSelectedUnit.Location = new System.Drawing.Point(464, 76);
            this.grpSelectedUnit.Name = "grpSelectedUnit";
            this.grpSelectedUnit.Size = new System.Drawing.Size(272, 384);
            this.grpSelectedUnit.TabIndex = 1;
            this.grpSelectedUnit.TabStop = false;
            this.grpSelectedUnit.Text = "Selected Unit Details";
            // 
            // bloodUnitDetailsTab1
            // 
            this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.bloodUnitDetailsTab1.BloodUnit = null;
            this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(8, 224);
            this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
            this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(256, 152);
            this.bloodUnitDetailsTab1.TabIndex = 1;
            // 
            // bloodBagLabel1
            // 
            this.bloodBagLabel1.BackColor = System.Drawing.Color.WhiteSmoke;
            this.bloodBagLabel1.BloodUnit = null;
            this.bloodBagLabel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.bloodBagLabel1.Location = new System.Drawing.Point(8, 16);
            this.bloodBagLabel1.Name = "bloodBagLabel1";
            this.bloodBagLabel1.Size = new System.Drawing.Size(257, 204);
            this.bloodBagLabel1.TabIndex = 0;
            this.bloodBagLabel1.TabStop = false;
            // 
            // tabUnits
            // 
            this.tabUnits.Controls.Add(this.pageAutologous);
            this.tabUnits.Controls.Add(this.pageAssigned);
            this.tabUnits.Location = new System.Drawing.Point(48, 76);
            this.tabUnits.Name = "tabUnits";
            this.tabUnits.SelectedIndex = 0;
            this.tabUnits.Size = new System.Drawing.Size(412, 384);
            this.tabUnits.TabIndex = 0;
            // 
            // pageAutologous
            // 
            this.pageAutologous.Controls.Add(this.lvAutologousUnits);
            this.pageAutologous.Location = new System.Drawing.Point(4, 23);
            this.pageAutologous.Name = "pageAutologous";
            this.pageAutologous.Size = new System.Drawing.Size(404, 357);
            this.pageAutologous.TabIndex = 0;
            this.pageAutologous.Text = "Autologous/Directed Units";
            // 
            // lvAutologousUnits
            // 
            this.lvAutologousUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAutologousUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader2,
            this.columnHeader3,
            this.columnHeader4,
            this.columnHeader5});
            this.lvAutologousUnits.FullRowSelect = true;
            this.lvAutologousUnits.Location = new System.Drawing.Point(4, 4);
            this.lvAutologousUnits.MultiSelect = false;
            this.lvAutologousUnits.Name = "lvAutologousUnits";
            this.lvAutologousUnits.Size = new System.Drawing.Size(396, 348);
            this.lvAutologousUnits.TabIndex = 0;
            this.lvAutologousUnits.UseCompatibleStateImageBehavior = false;
            this.lvAutologousUnits.View = System.Windows.Forms.View.Details;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Unit ID";
            this.columnHeader2.Width = 100;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Product";
            this.columnHeader3.Width = 80;
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "ABO/Rh";
            this.columnHeader4.Width = 80;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Expiration Date";
            this.columnHeader5.Width = 100;
            // 
            // pageAssigned
            // 
            this.pageAssigned.Controls.Add(this.lvAssignedUnits);
            this.pageAssigned.Location = new System.Drawing.Point(4, 23);
            this.pageAssigned.Name = "pageAssigned";
            this.pageAssigned.Size = new System.Drawing.Size(404, 357);
            this.pageAssigned.TabIndex = 1;
            this.pageAssigned.Text = "Crossmatched/Assigned Units";
            this.pageAssigned.Visible = false;
            // 
            // lvAssignedUnits
            // 
            this.lvAssignedUnits.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAssignedUnits.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader11,
            this.columnHeader12,
            this.columnHeader13,
            this.columnHeader14});
            this.lvAssignedUnits.FullRowSelect = true;
            this.lvAssignedUnits.Location = new System.Drawing.Point(4, 4);
            this.lvAssignedUnits.MultiSelect = false;
            this.lvAssignedUnits.Name = "lvAssignedUnits";
            this.lvAssignedUnits.Size = new System.Drawing.Size(396, 348);
            this.lvAssignedUnits.TabIndex = 0;
            this.lvAssignedUnits.UseCompatibleStateImageBehavior = false;
            this.lvAssignedUnits.View = System.Windows.Forms.View.Details;
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Unit ID";
            this.columnHeader11.Width = 100;
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "Product";
            this.columnHeader12.Width = 80;
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "ABO/Rh";
            this.columnHeader13.Width = 80;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Expiration Date";
            this.columnHeader14.Width = 100;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 32);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(732, 44);
            this.patientDisplayPanel1.TabIndex = 7;
            // 
            // DlgViewAutologousDirectedUnits
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.ClientSize = new System.Drawing.Size(736, 489);
            this.Controls.Add(this.patientDisplayPanel1);
            this.Controls.Add(this.tabUnits);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.grpImage);
            this.Controls.Add(this.grpSelectedUnit);
            this.hlphelpChm.SetHelpKeyword(this, "Accept_Orders.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(628, 516);
            this.Name = "DlgViewAutologousDirectedUnits";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Autologous, Directed, or Assigned Units";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.DlgViewAutologousDirectedUnits_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.grpSelectedUnit, 0);
            this.Controls.SetChildIndex(this.grpImage, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.tabUnits, 0);
            this.Controls.SetChildIndex(this.patientDisplayPanel1, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.grpSelectedUnit.ResumeLayout(false);
            this.tabUnits.ResumeLayout(false);
            this.pageAutologous.ResumeLayout(false);
            this.pageAssigned.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void DlgViewAutologousDirectedUnits_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			textToSpeak = this.bloodUnitDetailsTab1.GetErrorMessages();
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}
			
			//
			this.SpeakMessage( textToSpeak );
		}


		private void LoadForm(Guid patientGuid)
		{
			try
			{
				_dtUnits = BOL.BloodUnitMedia.GetBloodUnitsByPatient(patientGuid);

				foreach (System.Data.DataRow dr in _dtUnits.Rows)
				{

					BOL.BloodUnit bloodUnit = new BOL.BloodUnit((System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid]);

					
					// BR_16.12
					ListViewItem lVI = new ListViewItem();
					lVI.Text = bloodUnit.EyeReadableUnitId;
					lVI.SubItems.Add(bloodUnit.ProductShortName);
					lVI.SubItems.Add(bloodUnit.BloodUnitMedia.AboRh.AboRHText);
					lVI.SubItems.Add(Common.VBECSDateTime.FormatDateString(bloodUnit.BloodUnitMedia.UnitExpirationDate));
					//lVI.SubItems.Add(bloodUnit.BloodUnitMedia.IssueToLocationName);
					lVI.SubItems.Add(String.Empty);
					lVI.Tag = bloodUnit;

					if (bloodUnit.DonationType.DonationTypeId == 9 ||
						bloodUnit.DonationType.DonationTypeId == 10 ||
						bloodUnit.DonationType.DonationTypeId == 11 ||
						bloodUnit.DonationType.DonationTypeId == 12 ||
						bloodUnit.DonationType.DonationTypeId == 13 ||
						bloodUnit.DonationType.DonationTypeId == 14 ||
						bloodUnit.DonationType.DonationTypeId == 15 ||
						bloodUnit.DonationType.DonationTypeId == 16 ||
						bloodUnit.DonationType.DonationTypeId == 18)
					{
						this.lvAutologousUnits.Items.Add(lVI);
					}
				}
			}
			catch (Exception ex)
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
			}

		}

		#endregion


		#region events

		private void lvAutologousUnits_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if ( ((ListView) sender).SelectedIndices.Count > 0 )
			{

				try
				{
					ListView lV = (ListView) sender;
					ListViewItem lVI = lV.SelectedItems[0];
					BOL.BloodUnit bloodUnit = (BOL.BloodUnit) lVI.Tag;

					this.bloodBagLabel1.BloodUnit = bloodUnit;
					this.bloodUnitDetailsTab1.BloodUnit = bloodUnit;
				}
				catch (Exception ex)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.Dynamic(ex.Message));
				}
			}
		}

		#endregion
	}
}

